/****************************************************************************

	HoneyRadio
		Copyright(C) 2012 Mr.Honey

****************************************************************************/

#include "Main.h"
#include "Tick.h"

//=================================================================

static DWORD s_dwTick16 = 0;

//=================================================================

// 
extern void TickInit(void)
{
	T2CON = 0;
	T2CONbits.TCKPS = 0b111; // 1:256 prescaler
	PR2 = 0xFFFF;
	IPC2bits.T2IP = 7; // ōDx
	IEC0bits.T2IE = 1;
	T2CONbits.ON = 1;
}

// Tickl
extern DWORD TickGet(void)
{
	while (TMR2 == 0xFFFF);
	return ((s_dwTick16 << 16) | TMR2);
}

// Tickl(1/256)
extern DWORD TickGetDiv256(void)
{
	while (TMR2 == 0xFFFF);
	return ((s_dwTick16 << 8) | (TMR2 >> 8));
}

//=================================================================

// TMR2
void __ISR(_TIMER_2_VECTOR, ipl7) _T2Interrupt(void)
{
	ASSERT(TMR2 == 0x0000);
	s_dwTick16++;
	IFS0CLR = _IFS0_T2IF_MASK;
}
